DROP PROCEDURE [hips].[DownloadedDocumentGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon Massey
-- Create date:   12 Oct 2012
-- Description:   Gets a specific record from the DocumentType Table
-- Modified:
-- 10/03/2013 - sbiber - Extend to allow get by patient master or source system document id
-- =============================================
CREATE PROCEDURE [hips].[DownloadedDocumentGet] 
(
	@DownloadedDocumentId INT = NULL
	,@PatientMasterId INT = NULL
	,@SourceSystemDocumentId VARCHAR(256) = NULL
)
AS
BEGIN
SELECT  dd.DownloadedDocumentId,
		dd.PatientMasterId,
		dd.SourceSystemDocumentId,
		dd.Package,
		dd.DownloadedDate,
		dd.ClinicalDocumentStatusId,
		cs.Description,
		dd.CurrentDocumentId,
		dd.DateCreated,
		dd.UserCreated,
		dd.DateModified,
		dd.UserModified
		
FROM  hips.DownloadedDocument dd
INNER JOIN hips.ClinicalDocumentStatus AS cs ON dd.ClinicalDocumentStatusId = cs.ClinicalDocumentStatusId
WHERE (dd.DownloadedDocumentId = @DownloadedDocumentId OR @DownloadedDocumentId IS NULL)
AND (dd.PatientMasterId = @PatientMasterId OR @PatientMasterId IS NULL)
AND (dd.SourceSystemDocumentId = @SourceSystemDocumentId OR @SourceSystemDocumentId IS NULL)

END
GO

